/*
  the network protocol fundamentals - string list
  written by alexander yaworsky
  march '99
*/

#include <windows.h>

#include "stringlist.h"
#include "stdlib.h"
#include "switches.h"


void InitStringList( STRINGLIST* s )
  {
    s->Value = (char**) LocalAlloc( LMEM_FIXED, 4096 );
    s->Size = 4096 / sizeof(char*);
    s->Count = 0;
    s->Increment = 4096 / sizeof(char*);
  }

int  AddToStringList( STRINGLIST* s, char* str )
  {
    char** vp;
    char*  cp;

    if( s->Increment < 1 ) s->Increment = 16;
    if( s->Count == s->Size ) {
      vp = (char**) LocalReAlloc( (HLOCAL) s->Value,
                             (s->Size + s->Increment) * sizeof(char*), 0 );
      if( vp == NULL ) return 0;
      s->Value = vp;
      s->Size += s->Increment;
    }
    cp = (char*) LocalAlloc( LMEM_FIXED, lstrlen( str ) + 1 );
    if( cp == NULL ) return 0;
    lstrcpy( cp, str );
    s->Value[ s->Count++ ] = cp;
    return 1;
  }

void FreeStringList( STRINGLIST* s )
  {
    int  i;

    for( i = 0; i < s->Count; i++ ) LocalFree( s->Value[i] );
    LocalFree( s->Value );
  }
